/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core.ui.views;

import com.aptana.index.core.ui.views.IActionProvider;
import com.aptana.index.core.ui.views.IndexViewActionProvider;
import com.aptana.index.core.ui.views.IndexViewContentProvider;
import com.aptana.index.core.ui.views.IndexViewLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class IndexView
extends ViewPart {
    private TreeViewer treeViewer;
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private IActionProvider actionProvider;

    private void addListeners() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addPostSelectionListener("org.eclipse.ui.navigator.ProjectExplorer", new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part != IndexView.this && selection instanceof IStructuredSelection) {
                    IndexView.this.setInputFromSelection(selection);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.contentProvider = new IndexViewContentProvider();
        this.labelProvider = new IndexViewLabelProvider();
        this.actionProvider = new IndexViewActionProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IBaseLabelProvider provider;
                String name1 = null;
                String name2 = null;
                if (viewer != null && viewer instanceof ContentViewer && (provider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
                    ILabelProvider labelProvider = (ILabelProvider)provider;
                    name1 = labelProvider.getText(e1);
                    name2 = labelProvider.getText(e2);
                }
                if (name1 == null) {
                    name1 = e1.toString();
                }
                if (name2 == null) {
                    name2 = e2.toString();
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        this.setInputFromSelection(selection);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.hookContextMenu();
        this.addListeners();
    }

    private void fillContextMenu(IMenuManager manager) {
        IAction[] actions;
        TreeSelection treeSelection;
        Object item;
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof TreeSelection && (item = (treeSelection = (TreeSelection)selection).getFirstElement()) != null && (actions = this.actionProvider.getActions(this, item)) != null) {
            IAction[] iActionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                manager.add(action);
                ++n2;
            }
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IndexView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    public void setFocus() {
    }

    private void setInputFromSelection(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss != null && this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            for (Object item : ss) {
                if (!(item instanceof IResource)) continue;
                IProject project = ((IResource)item).getProject();
                if (project.isOpen()) {
                    this.treeViewer.setInput((Object)project);
                    break;
                }
                this.treeViewer.setInput(null);
                break;
            }
        }
    }
}

